const ALL_LOCALES = {
    'zh-CN': {
        // Header
        'app.title': 'AntiMark',
        'app.desc': 'AI 驱动的推特书签管理工具',

        // Components
        'status.active': '系统运行中',
        'status.ready': '随时准备捕获',
        'stats.total': '总收藏',
        'stats.today': '今日',
        'recent.title': '最近活动',
        'recent.viewAll': '查看全部',
        'recent.empty': '暂无最近收藏',

        // History
        'history.search': '搜索收藏记录...',
        'history.empty': '还没有收藏记录',
        'history.clear': '清空历史记录',
        'history.confirmClear': '确定要清空所有历史记录吗？',
        'history.openLink': '打开链接',

        // Settings Groups
        'settings.general': '通用设置',
        'settings.intelligence': '智能服务',
        'settings.storage': '存储设置',

        // Settings - General
        'settings.language': '界面语言',
        'settings.theme': '外观主题',
        'theme.auto': '跟随系统',
        'theme.light': '浅色模式',
        'theme.dark': '深色模式',

        // Settings - AI
        'settings.aiEnhance': 'AI 增强',
        'settings.aiEnhance.sub': '摘要与事实核查',
        'settings.provider': '模型提供商',
        'settings.summaryLang': '摘要语言',
        'settings.apiKey': 'API Key',
        'settings.model': '模型版本',
        'settings.baseUrl': 'Base URL',
        'settings.savePath': 'Save Path',
        'settings.pickFolder': 'Pick Folder',
        'settings.clearFolder': 'Clear',
        'settings.nativeSetup': 'Setup Native Host',

        // Shortcuts Modal
        'shortcuts.title': 'Keyboard Shortcuts',
        'shortcuts.global': 'Global',
        'shortcuts.search': 'Focus search input',
        'shortcuts.save': 'Save settings',
        'shortcuts.clear': 'Clear search / Close modals',
        'shortcuts.help': 'Show this help',

        // Settings - Storage
        'settings.autoDownload': '自动下载',
        'settings.autoDownload.sub': '保存 .md 到本地',
        'settings.saveMode': '保存模式',
        'mode.tldr': 'AI 摘要模式',
        'mode.original': '原文模式',
        'settings.savePath': '保存路径',
        'path.default': '默认 (下载文件夹)',
        'path.select': '选择文件夹',
        'path.setup': '需安装 Native Host',

        // Footer
        'footer.updateAvailable': '发现新版本 v{version}',
        'footer.repo': 'GitHub 仓库',

        // Content Script (Injected Card)
        'card.summary': 'AI 摘要',
        'card.keyPoints': '关键点',
        'card.credibility': '可信度',
        'card.analyze': '正在生成摘要...',
        'card.analyzing': '正在生成摘要...',
        'card.savingOriginal': '正在保存原文...',
        'card.copy': '复制',
        'card.save': '保存',
        'card.saving': '保存中...',
        'card.saved': '已保存',
        'card.savedOriginal': '已保存原文到 Markdown',
        'card.failed': '失败',
        'card.close': '关闭',
        'card.noContent': '未找到可总结的内容',
        'card.connFailed': '扩展连接失败，请刷新页面',
        'card.viewOriginal': '查看原帖 \u2197',
        'card.error': '处理出错',

        'card.credibilityLabel': '可信度',
    },
    'en': {
        // Header
        'app.title': 'AntiMark',
        'app.desc': 'AI-powered bookmark manager for X',

        // Components
        'status.active': 'System Active',
        'status.ready': 'Ready to Capture',
        'stats.total': 'Total Saved',
        'stats.today': 'Today',
        'recent.title': 'Recent Activity',
        'recent.viewAll': 'View All',
        'recent.empty': 'No recent bookmarks',

        // History
        'history.search': 'Search saved items...',
        'history.empty': 'No history found',
        'history.clear': 'Clear History',
        'history.confirmClear': 'Are you sure you want to clear all history?',
        'history.openLink': 'Open Link',

        // Settings Groups
        'settings.general': 'General',
        'settings.intelligence': 'Intelligence',
        'settings.storage': 'Storage',

        // Settings - General
        'settings.language': 'Language',
        'settings.theme': 'Theme',
        'theme.auto': 'System',
        'theme.light': 'Light',
        'theme.dark': 'Dark',

        // Settings - AI
        'settings.aiEnhance': 'AI Enhancements',
        'settings.aiEnhance.sub': 'Summary & Fact Check',
        'settings.provider': 'Model Provider',
        'settings.summaryLang': 'Summary Language',
        'settings.apiKey': 'API Key',
        'settings.model': 'Model Version',
        'settings.baseUrl': 'Base URL',

        // Settings - Storage
        'settings.autoDownload': 'Auto Download',
        'settings.autoDownload.sub': 'Save .md to disk',
        'settings.saveMode': 'Save Mode',
        'mode.tldr': 'TLDR Mode',
        'mode.original': 'Original Mode',
        'settings.savePath': 'Save Location',
        'path.default': 'Default (Downloads)',
        'path.select': 'Select Folder',
        'path.setup': 'Native Host Required',

        // Footer
        'footer.updateAvailable': 'Update available v{version}',
        'footer.repo': 'GitHub Repo',

        // Content Script (Injected Card)
        'card.summary': 'Summary',
        'card.keyPoints': 'Key Points',
        'card.credibility': 'Credibility',
        'card.analyze': 'Analyzing...',
        'card.analyzing': 'Generating Summary...',
        'card.savingOriginal': 'Saving Original...',
        'card.copy': 'Copy',
        'card.save': 'Save',
        'card.saving': 'Saving...',
        'card.saved': 'Saved',
        'card.savedOriginal': 'Saved Original to Markdown',
        'card.failed': 'Failed',
        'card.close': 'Close',
        'card.noContent': 'No content found to summarize',
        'card.connFailed': 'Extension connection failed, please refresh',
        'card.viewOriginal': 'View Original \u2197',
        'card.error': 'Error processing',

        'card.credibilityLabel': 'Credibility',
    }
};

// Helper: Get translation
function t(key, lang = 'zh-CN', params = {}) {
    const dict = ALL_LOCALES[lang] || ALL_LOCALES['zh-CN'];
    let str = dict[key] || key;

    // Replace params {param}
    Object.keys(params).forEach(k => {
        str = str.replace(new RegExp(`{${k}}`, 'g'), params[k]);
    });

    return str;
}
