# AntiMark - Don't just mark it, master it.

> An AI-powered Twitter bookmark manager that transforms your bookmarks into organized knowledge with intelligent summaries and local Markdown exports.

[English](#english) | [中文](#chinese)

🌐 **Official Website**: https://antimark.vibedegens.com

🐦 **Follow us**: https://x.com/sciencedegens

---

<a name="english"></a>

## ✨ Features

### 🎯 Core Features
- **AI-Powered Summaries** - Automatically generate structured TLDR summaries with key points and insights
- **Multi-Model Support** - Choose from OpenAI (GPT), Claude (Anthropic), Kimi (Moonshot), and Zhipu (GLM)
- **Smart Content Extraction** - Auto-expands truncated content, fetches full X Articles, and retrieves quoted posts
- **Local Markdown Export** - Every bookmark is saved as a beautifully formatted Markdown file
- **History Management** - Search, filter, and organize all your bookmarks with tags
- **Dark Mode** - Beautiful glassmorphism UI with automatic theme switching

### 🚀 Power User Features
- **Keyboard Shortcuts** - `Cmd/Ctrl+K` to search, `Cmd/Ctrl+S` to save, `?` for help
- **Export/Import** - Backup your bookmarks in JSON, Markdown, or CSV formats
- **Tags System** - Organize bookmarks with custom tags
- **Real-time Search** - Instant filtering with live highlighting
- **Bilingual Support** - Full English and Chinese interface

## 📸 Screenshots

### Dashboard
![Dashboard](screenshots/dashboard.png)

### History & Search
![History](screenshots/history.png)

### Settings
![Settings](screenshots/settings.png)

### Keyboard Shortcuts
![Shortcuts](screenshots/shortcuts.png)

## 🚀 Installation

1. **Download the extension**
   - Visit https://antimark.vibedegens.com
   - Click the **Download AntiMark v2.0.0** button
   - Unzip the downloaded file

2. **Load in Chrome**
   - Open Chrome and navigate to `chrome://extensions/`
   - Enable **Developer mode** (top right toggle)
   - Click **Load unpacked** and select the `AntiMark` folder

3. **Configure**
   - Click the extension icon in your toolbar
   - Select your preferred AI model
   - Enter your API key
   - Choose summary language and save mode

## 📖 Usage

### Basic Workflow
1. **Bookmark** - Click the bookmark button on any Twitter post
2. **AI Processing** - AntiMark extracts content and generates a summary
3. **Review** - A TLDR card appears with key insights
4. **Save** - Automatically saved to history and exported as Markdown

### Keyboard Shortcuts
- `Cmd/Ctrl + K` - Focus search input
- `Cmd/Ctrl + S` - Save settings
- `Esc` - Clear search / Close modals
- `?` - Show keyboard shortcuts help

### Export & Import
- **Export** - Download your bookmarks as JSON, Markdown, or CSV
- **Import** - Restore bookmarks from JSON with smart deduplication

## 🎨 Markdown Format

Each bookmark is saved as a `.md` file:

```markdown
# Post Title or Author Name

> **Author**: @username
> **Source**: https://x.com/user/status/123456
> **Date**: 2026-02-17 04:00
> **Tags**: #ai, #productivity

---

## TLDR

AI-generated structured summary with key points and insights

---

## Original Content

Full original tweet text

### Quoted Content (by @quoteduser)

Full quoted/retweeted content (if applicable)
```

## 🔑 Getting API Keys

| Provider | URL |
|----------|-----|
| OpenAI | https://platform.openai.com/api-keys |
| Claude | https://console.anthropic.com/settings/keys |
| Kimi | https://platform.moonshot.cn/console/api-keys |
| Zhipu | https://open.bigmodel.cn/usercenter/apikeys |

## 🛠 Default Models

| Provider | Default Model |
|----------|--------------|
| OpenAI | `gpt-4o-mini` |
| Claude | `claude-sonnet-4-20250514` |
| Kimi | `moonshot-v1-8k` |
| Zhipu | `glm-4-flash` |

You can customize the model version in settings.

## 📁 Project Structure

```
AntiMark/
├── manifest.json          # Chrome extension config (Manifest V3)
├── background.js          # Service worker (API calls, history management)
├── content.js             # Content script (bookmark detection, UI)
├── content.css            # Content script styles (glassmorphism)
├── popup.html             # Extension popup (dashboard, history, settings)
├── popup.js               # Popup logic (navigation, data management)
├── popup.css              # Popup styles (modern dark theme)
├── locales.js             # Bilingual translations (EN/CN)
└── icons/                 # Extension icons
    ├── icon16.png
    ├── icon48.png
    └── icon128.png
```

## 📄 License

MIT License

---

<a name="chinese"></a>

# AntiMark - 不只是收藏，更要掌握

> 一款 AI 驱动的推特书签管理器，将你的书签转化为有组织的知识，提供智能摘要和本地 Markdown 导出。

[English](#english) | [中文](#chinese)

🌐 **官方网站**: https://antimark.vibedegens.com

🐦 **关注我们**: https://x.com/sciencedegens

---

## ✨ 功能特点

### 🎯 核心功能
- **AI 智能摘要** - 自动生成结构化 TLDR 摘要，提炼要点和洞察
- **多模型支持** - 支持 OpenAI (GPT)、Claude (Anthropic)、Kimi (月之暗面)、智谱 (GLM)
- **智能内容提取** - 自动展开折叠内容，获取 X Articles 全文，提取引用帖
- **本地 Markdown 导出** - 每个书签都保存为精美的 Markdown 文件
- **历史管理** - 搜索、过滤和使用标签组织所有书签
- **深色模式** - 精美的玻璃态 UI，支持自动主题切换

### 🚀 高级功能
- **键盘快捷键** - `Cmd/Ctrl+K` 搜索，`Cmd/Ctrl+S` 保存，`?` 查看帮助
- **导出/导入** - 以 JSON、Markdown 或 CSV 格式备份书签
- **标签系统** - 使用自定义标签组织书签
- **实时搜索** - 即时过滤，实时高亮显示
- **双语支持** - 完整的中英文界面

## 📸 截图

### 仪表板
![仪表板](screenshots/dashboard.png)

### 历史记录与搜索
![历史记录](screenshots/history.png)

### 设置
![设置](screenshots/settings.png)

### 键盘快捷键
![快捷键](screenshots/shortcuts.png)

## 🚀 安装方法

1. **下载扩展**
   - 访问 https://antimark.vibedegens.com
   - 点击**下载 AntiMark v2.0.0** 按钮
   - 解压下载的文件

2. **在 Chrome 中加载**
   - 打开 Chrome 并访问 `chrome://extensions/`
   - 启用**开发者模式**（右上角开关）
   - 点击**加载已解压的扩展程序**，选择 `AntiMark` 文件夹

3. **配置**
   - 点击工具栏中的扩展图标
   - 选择你喜欢的 AI 模型
   - 输入你的 API 密钥
   - 选择摘要语言和保存模式

## 📖 使用方法

### 基本流程
1. **收藏** - 点击任意推文的收藏按钮
2. **AI 处理** - AntiMark 提取内容并生成摘要
3. **查看** - 弹出 TLDR 卡片显示关键洞察
4. **保存** - 自动保存到历史记录并导出为 Markdown

### 键盘快捷键
- `Cmd/Ctrl + K` - 聚焦搜索框
- `Cmd/Ctrl + S` - 保存设置
- `Esc` - 清空搜索 / 关闭弹窗
- `?` - 显示键盘快捷键帮助

### 导出与导入
- **导出** - 将书签下载为 JSON、Markdown 或 CSV 格式
- **导入** - 从 JSON 恢复书签，智能去重

## 🎨 Markdown 格式

每个书签保存为 `.md` 文件：

```markdown
# 帖子标题或作者名

> **Author**: @username
> **Source**: https://x.com/user/status/123456
> **Date**: 2026-02-17 04:00
> **Tags**: #ai, #productivity

---

## TLDR

AI 生成的结构化摘要，包含要点和洞察

---

## Original Content

完整的原始推文文本

### Quoted Content (by @quoteduser)

完整的引用/转发内容（如有）
```

## 🔑 获取 API 密钥

| 提供商 | 网址 |
|--------|------|
| OpenAI | https://platform.openai.com/api-keys |
| Claude | https://console.anthropic.com/settings/keys |
| Kimi | https://platform.moonshot.cn/console/api-keys |
| 智谱 | https://open.bigmodel.cn/usercenter/apikeys |

## 🛠 默认模型

| 提供商 | 默认模型 |
|--------|---------|
| OpenAI | `gpt-4o-mini` |
| Claude | `claude-sonnet-4-20250514` |
| Kimi | `moonshot-v1-8k` |
| 智谱 | `glm-4-flash` |

你可以在设置中自定义模型版本。

## 📁 项目结构

```
AntiMark/
├── manifest.json          # Chrome 扩展配置 (Manifest V3)
├── background.js          # Service Worker（API 调用、历史管理）
├── content.js             # 内容脚本（书签检测、UI）
├── content.css            # 内容脚本样式（玻璃态效果）
├── popup.html             # 扩展弹窗（仪表板、历史、设置）
├── popup.js               # 弹窗逻辑（导航、数据管理）
├── popup.css              # 弹窗样式（现代深色主题）
├── locales.js             # 双语翻译（中英文）
└── icons/                 # 扩展图标
    ├── icon16.png
    ├── icon48.png
    └── icon128.png
```

## 📄 许可证

MIT License
