# AntiMark Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [2.0.0] - 2026-02-17

### Added
- **Tags System**: Add custom tags to bookmarks with inline editing
- **Export/Import**: Export history in JSON, Markdown, or CSV formats
- **Full-Text Search**: Real-time search with highlighting and result count
- **Keyboard Shortcuts**: Cmd+K for search, Cmd+S for save, Escape for clear
- **7-Day Trend**: Visual indicator showing bookmark activity trends
- **Glassmorphism UI**: Modern design with backdrop blur and smooth animations
- **Search Debouncing**: Optimized search performance with 300ms debounce
- **Tag Filtering**: Filter bookmarks by tags
- **Import Deduplication**: Automatically prevent duplicate entries when importing

### Enhanced
- **Dashboard**: Added trend indicator and improved stat cards
- **History Search**: Implemented real-time filtering with match highlighting
- **Settings Page**: Added all missing UI elements (model, baseUrl, mdMode, API key toggle)
- **Content Script**: Enhanced TLDR cards with glassmorphism effects
- **Error Handling**: More specific error messages with recovery suggestions
- **Base URL Placeholder**: Dynamic placeholder showing provider-specific defaults

### Fixed
- **API Key Persistence**: Fixed auto-save functionality
- **Extension Context**: Resolved "Extension context invalidated" errors
- **Null Reference Errors**: Added defensive null checks throughout
- **CSS Syntax**: Fixed malformed CSS in content.css
- **Search Highlighting**: Properly escape HTML in search results

### Changed
- **Version**: Bumped to 2.0.0 for major feature release
- **UI Theme**: Switched to dark mode by default with Binance-inspired color palette
- **Recent Activity**: Simplified display to show only author and date
- **Status Toast**: Increased display duration to 3 seconds

## [1.0.1] - 2026-01-XX

### Initial Release
- Basic bookmark capture from X/Twitter
- AI-powered TLDR generation
- Multi-provider support (OpenAI, Claude, Kimi, Zhipu)
- History management
- Markdown download
- Multi-language support (EN/CN)

---

## Upgrade Notes

### 2.0.0
- **Breaking**: None - fully backward compatible
- **Migration**: Existing bookmarks will automatically gain tags field (empty array)
- **Recommendation**: Export your history as backup before upgrading

---

## Future Roadmap

### Planned for 2.1.0
- Lazy loading for large history lists
- Advanced tag autocomplete
- Keyboard shortcuts help modal
- Empty state illustrations
- Quick action buttons in dashboard

### Under Consideration
- Browser sync across devices
- Bookmark folders/collections
- Scheduled exports
- Advanced analytics dashboard
- Browser extension for Firefox and Edge
